#!/usr/bin/env python3

import h5py
import numpy as np

from keras.models import load_model, Sequential, Model
from keras.utils import to_categorical
from keras.layers import Dense, BatchNormalization

hf = h5py.File("ASCAD_data/ASCAD_databases/ASCAD.h5","r")
Utrain = np.array(hf['Profiling_traces/traces'])
Strain = np.array(hf['Profiling_traces/labels'])
Utest = np.array(hf['Attack_traces/traces'])
Stest = np.array(hf['Attack_traces/labels'])

m = Sequential([
	BatchNormalization(input_shape=(700,), trainable = False), 
	Dense(50, activation='relu'),
	Dense(50, activation='relu'),
	Dense(50, activation='relu'),
	Dense(50, activation='relu'),
	Dense(50, activation='relu'),
	Dense(256, activation='softmax')
])

m.compile(
	optimizer='adam',
	loss='categorical_crossentropy',
	metrics=['accuracy']
)

# weights for non-trainable BN
W = m.get_weights()
W[0] = np.ones(700)
W[1] = np.zeros(700)
W[2] = Utrain.mean(0)
W[3] = Utrain.var(0)
m.set_weights(W)

H = m.fit(Utrain, to_categorical(Strain),
	batch_size = 200,
	epochs = 25,
)

outname = 'other_mlp_01.h5'
m.save(outname)
print('model saved in %s' % outname)

