import numpy as np

f = open('simple_model.bin', 'rb')
pr = np.fromfile(f, dtype=np.float32, count=10*700).reshape(700,10)
mR = np.fromfile(f, dtype=np.float32, count=10*256).reshape(256,10)
mX = np.fromfile(f, dtype=np.float32, count=10*256).reshape(256,10)
f.close()

S = np.tile(np.arange(0x100, dtype = np.uint8).reshape(1,256), (256,1))
R = np.tile(np.arange(0x100, dtype = np.uint8).reshape(256,1), (1,256))
X = S ^ R

m = mR[R,:] + mX[X,:]

def predict(batch):
	upr = batch.dot(pr).reshape(-1,1,1,10)
	return np.exp(-.5 * ((upr - m) ** 2).sum(3)).sum(1)

